<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
/* @var $this yii\web\View */
/* @var $searchModel backend\models\RegistrationsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = Yii::t('app', 'Registrations');
$this->params['breadcrumbs'][] = $this->title;
?>
<?= Html::beginForm(['registration/bulk'],'post'); ?>
<div class="row">
    <div class="col-md-4">
        <h1><?= Html::encode($this->title) ?></h1>
    </div>
    <div class="col-md-8">
        <span class="pull-right">
            <?=Html::dropDownList('action','',
                [
                    ''=>'Actions : ',
                    'resend-emails'=>'Resend Emails',
                    //'nc'=>'No Confirmed'
                ],
                ['class'=>'dropdown',]);
            ?>
            <?= Html::submitButton('Update', ['class' => 'btn btn-info',]);?>
            <?= Html::a(Yii::t('app', 'Create Registrations'), ['create'], ['class' => 'btn btn-success']) ?>
        </span>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <?php Pjax::begin(); ?>
        <?php // echo $this->render('_search', ['model' => $searchModel]); ?>
        <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'filterModel' => $searchModel,
            'columns' => [   
                [
                    'class' => 'yii\grid\CheckboxColumn',
                    // you may configure additional properties here
                ],
                ['class' => 'yii\grid\SerialColumn'],
                //'id',
                //'user_id',
                
                'registration_no',
                //'created_at',
                [
                    'attribute' => 'created_on',
                    'label' => 'Created On',
                    'value' => 'created_at',
                    'format' => 'date',//date, datetime, time
                    'headerOptions' => ['width' => '200'],
                ],
                'type_of_registration',
                'handler_first_name',
                'handler_last_name',
                //'handler_street',
                //'handler_city',
                //'handler_state',
                //'handler_zip',
                'handler_phone',
                'dog_name',
                'dog_breed',
                'source',
                [
                    'attribute' => 'username',
                    'value' => 'user.username'
                ],
                //'user.username',
                'user_ip',
                
                //'updated_at',

                //['class' => 'yii\grid\ActionColumn'],
                [

                'class' => 'yii\grid\ActionColumn',

                    'template' => '{view}{update}{delete}',

                    'visible' => (Yii::$app->user->identity->type == 1),

                    'options' => ['width' => '120'],

                ],
                [

                'class' => 'yii\grid\ActionColumn',

                    'template' => '{view}',

                    'visible' => (Yii::$app->user->identity->type == 2),

                    'options' => ['width' => '120'],

                ],
            ],
        ]); ?>
        <?php Pjax::end(); ?>
    </div>
</div>
<?= Html::endForm(); ?> 