<?php

namespace common\components;

Class Klaviyo {

	public static function Create ($user){

        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://a.klaviyo.com/api/profiles/',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
          "data": {
            "type": "profile",
            "attributes": {
                "email": "' . $user->email . '",
                "phone_number": "' . self::KlaviyoPhoneNumber($user->handler_phone) . '",
                "external_id": "' . microtime(true) . '",
              "anonymous_id": "",
              "first_name": "' . $user->handler_first_name . '",
              "last_name": "' . $user->handler_last_name . '",
              "organization": "",
              "title": "",
              "image": "",
              "location": {
                "address1": "' . $user->handler_street . '",
                "address2": "",
                "city": "' . $user->handler_city . '",
                "country": "USA",
                "latitude": {
                  "value": ""
                },
                "longitude": {
                  "value": ""
                },
                "region": "'. $user->handler_state . '",
                "zip": "'. $user->handler_zip . '",
                "timezone": ""
              },
              "properties": {
                    "Accepts Marketing": "True",
                    "Registration Type": "' . $user->type_of_registration . '",
                    "Dog Name": "' . $user->dog_name . '",
                    "Dog Breed": "' . $user->dog_breed . '"
              }
            }
          }
        }',
          CURLOPT_HTTPHEADER => array(
            'revision: 2022-10-17',
            'Content-Type: application/json',
            'Accept: application/json',
            'Authorization: Klaviyo-API-Key pk_417df30b39426015fe1870791dc741448c'
          ),
        ));


        $response = curl_exec($curl);

        $err = curl_error($curl);

        curl_close($curl);



        if ($err) {

          // echo "cURL Error #:" . $err;

          // send email to admin.
          // mail( 'darren@fastnet.agency', 'Klaviyo - ERROR - Profile', $err );

        } else {

            // send email to admin.
            // mail( 'darren@fastnet.agency', 'Klaviyo - SUCCESS - Profile', $response );

            $response_string = json_decode( $response );
            // echo print_r( $response_string );

            // Start
            // Profile has been created, now subscribe to a list

            $curl_subscribe = curl_init();

            // Check if profile request returns success or failure.
            $id_data = $response_string->data->id; // Success.
            if ( empty( $id_data ) ) {
                $id_data = $response_string->errors[0]->meta->duplicate_profile_id; // Failure.
            }

            curl_setopt_array($curl_subscribe, array(
              CURLOPT_URL => 'https://a.klaviyo.com/api/lists/UKrcur/relationships/profiles/',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'POST',
              CURLOPT_POSTFIELDS =>'{
                  "data": [
                    {
                      "type": "profile",
                      "id": "' . $id_data . '"
                    }
                  ]
                }',
              CURLOPT_HTTPHEADER => array(
                'revision: 2023-01-24',
                'Content-Type: application/json',
                'Accept: application/json',
                'Authorization: Klaviyo-API-Key pk_417df30b39426015fe1870791dc741448c'
              ),
            ));

            $response_subscribe = curl_exec($curl_subscribe);

            $err_subscribe = curl_error($curl_subscribe);

            curl_close($curl_subscribe);
            // echo $response_subscribe;


            if ($err_subscribe) {
              // echo "cURL Error #:" . $err_subscribe;

              //send email to admin
              // mail( 'darren@fastnet.agency', 'Klaviyo - ERROR - List', $err_subscribe );

            } else {

              //send email to admin
              // mail( 'darren@fastnet.agency', 'Klaviyo - SUCCESS - List', $response_subscribe );

            }

            // End

        }

        // echo $response;

	}

    public static function KlaviyoPhoneNumber($no){

        // https://stackoverflow.com/questions/52815213/format-a-phone-number-detect-and-add-the-country-code-if-missing

        $number = trim($no);
        $number = str_replace(' ', '', $number);
        $number = str_replace('-', '', $number);
        // $number = stripslashes($number);
        // $number = htmlspecialchars($number);

        //strip out everything but numbers
        $number =  preg_replace("/[^0-9]/", "", $number);
        //Strip out leading zeros:
        $number = ltrim($number, '0');
        //The default country code
        $default_country_code  = '+1';
        //Check if the number doesn't already start with the correct dialling code:
        if ( !preg_match('/^[+]'.$default_country_code.'/', $number)  ) {
            $number = $default_country_code.$number;
        }

        //return the converted number:
        return $number;

    }
}