<?php

namespace frontend\controllers;

use Yii;
use common\models\Registrations;
use common\models\RegistrationsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\models\User;
use common\models\Influencers;
use \DrewM\MailChimp\MailChimp;
use common\components\Omnisend;
use common\components\Klaviyo;

/**
 * RegistrationController implements the CRUD actions for Registrations model.
 */
class RegistrationController extends Controller
{
    public function actions()
    {
        return [
            // ...
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => \yii\filters\AccessControl::className(),
                'only' => ['create', 'update', 'search'],
                'rules' => [
                    // deny all POST requests
                    // [
                    //     'allow' => false,
                    //     'verbs' => ['POST']
                    // ],
                    // allow authenticated users
                    [
                        'actions' => ['create', 'update', 'index', 'search', 'resend'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                    [
                        'actions' => ['create', 'search'],
                        'allow' => true,
                        'roles' => ['?'],
                    ],
                    // everything else is denied
                ],
            ],
        ];
    }

    /**
     * Lists all Registrations models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new RegistrationsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Registrations model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    // public function actionView($id)
    // {
    //     return $this->render('view', [
    //         'model' => $this->findModel($id),
    //     ]);
    // }

    /**
     * Creates a new Registrations model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreateOriginalOmnisend($source = null)
    {
        $model = new Registrations();
        $model->scenario = Registrations::SCENARIO_CREATE;

        $post = Yii::$app->request->post();

        $influencer = Influencers::findOne(['name' => $source]);

        if (!isset($influencer)){
            $source = "none";
        }

        if(!empty($post)){
            $load = $model->load($post);

            //check if user exists
            $oldUser = User::findOne(['email' => $post['Registrations']['email']]);
            if(!$oldUser){
                $user = new User();
                $user->username = $post['Registrations']['email'];
                $user->email = $post['Registrations']['email'];
                $user->setPassword($post['Registrations']['password']);
                $user->generateAuthKey();
                if(!$user->save())
                    throw new \yii\web\HttpException(500, 'Error creating user, please contact the administrator.');
                    
            }
            else{
                $user = $oldUser;
            }

            if ($load) {
                $model->user_id = $user->id;
                $model->registration_no = $model->generateUniqueRandomString();
                $model->user_ip = Yii::$app->getRequest()->getUserIP();
                $model->source = $source;
                
                //$model->created_at = time();
                //$model->updated_at = time();
            }

            if($model->save()){
                //send email to user
                Yii::$app
                ->mailer
                ->compose(
                    ['html' => 'registration-html', 'text' => 'registration-text'],
                    ['model' => $model]
                )
                ->setFrom([Yii::$app->params['supportEmail'] => Yii::$app->name])
                ->setTo($user->email)
                //->setCc(['saq1b.zaf4r@gmail.com'])
                ->setBcc(['register@federalservicedogregistration.org','portal@federalservicedogregistration.org'])
                ->setSubject($model->dog_name.'\'s Registration # = '.$model->registration_no.' (Federal Service Dog Registration)')
                ->send();
                
                // create mailchimp subscription
                // turned off mailchimp subscription in favor of omnisend on 19th may 2019
                /*$MailChimp = new MailChimp('4c2ad6fa1f62817524b35a290b07cbd9-us12');

                $list_id = '985c43c01c';

                $result = $MailChimp->post("lists/$list_id/members", [
                                'email_address' => $user->email,
                                'merge_fields' => ['FNAME'=>$model->handler_first_name, 'LNAME'=>$model->handler_last_name],
                                'status'        => 'subscribed',
                            ]);*/

                
                //subscribe to omnisend list
                Omnisend::create($model);

                // return $this->redirect('https://shoptopdogproducts.com/pages/registration-successful', 301);

                if($model->type_of_registration == "Service Dog")
                    return $this->redirect('https://shoptopdogproducts.com/pages/service-dog-postregistration', 301);
                elseif($model->type_of_registration == "Emotional Support Animal")
                    return $this->redirect('https://shoptopdogproducts.com/pages/esa-postregistration', 301);
                else    
                    return $this->redirect('https://shoptopdogproducts.com/pages/registration-successful', 301);
            }
                
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Creates a new Registrations model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($source = null)
    {
        $model = new Registrations();
        $model->scenario = Registrations::SCENARIO_CREATE;

        $post = Yii::$app->request->post();

        $influencer = Influencers::findOne(['name' => $source]);

        if (!isset($influencer)){
            $source = "none";
        }

        if(!empty($post)){
            $load = $model->load($post);

            //check if user exists
            $oldUser = User::findOne(['email' => $post['Registrations']['email']]);
            if(!$oldUser){
                $user = new User();
                $user->username = $post['Registrations']['email'];
                $user->email = $post['Registrations']['email'];
                $user->setPassword($post['Registrations']['password']);
                $user->generateAuthKey();
                if(!$user->save())
                    throw new \yii\web\HttpException(500, 'Error creating user, please contact the administrator.');

            }
            else{
                $user = $oldUser;
            }

            if ($load) {
                $model->user_id = $user->id;
                $model->registration_no = $model->generateUniqueRandomString();
                $model->user_ip = Yii::$app->getRequest()->getUserIP();
                $model->source = $source;

                //$model->created_at = time();
                //$model->updated_at = time();
            }

            if($model->save()){
                //send email to user
                Yii::$app
                ->mailer
                ->compose(
                    ['html' => 'registration-html', 'text' => 'registration-text'],
                    ['model' => $model]
                )
                ->setFrom([Yii::$app->params['supportEmail'] => Yii::$app->name])
                ->setTo($user->email)
                // ->setCc(['darren@fastnet.agency'])
                ->setBcc(['register@federalservicedogregistration.org','portal@federalservicedogregistration.org'])
                ->setSubject($model->dog_name.'\'s Registration # = '.$model->registration_no.' (Federal Service Dog Registration)')
                ->send();

                // create mailchimp subscription
                // turned off mailchimp subscription in favor of omnisend on 19th may 2019
                /*$MailChimp = new MailChimp('4c2ad6fa1f62817524b35a290b07cbd9-us12');

                $list_id = '985c43c01c';

                $result = $MailChimp->post("lists/$list_id/members", [
                                'email_address' => $user->email,
                                'merge_fields' => ['FNAME'=>$model->handler_first_name, 'LNAME'=>$model->handler_last_name],
                                'status'        => 'subscribed',
                            ]);*/


                //subscribe to omnisend list
                // Omnisend::create($model);
                Klaviyo::create($model);

                // return $this->redirect('https://shoptopdogproducts.com/pages/registration-successful', 301);

                if($model->type_of_registration == "Service Dog")
                    return $this->redirect('https://shoptopdogproducts.com/pages/service-dog-postregistration', 301);
                elseif($model->type_of_registration == "Emotional Support Animal")
                    return $this->redirect('https://shoptopdogproducts.com/pages/esa-postregistration', 301);
                else
                    return $this->redirect('https://shoptopdogproducts.com/pages/registration-successful', 301);
            }

        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    public function actionTestreg (){
        $MailChimp = new MailChimp('4c2ad6fa1f62817524b35a290b07cbd9-us12');

        $list_id = '985c43c01c';

        $result = $MailChimp->post("lists/$list_id/members", [
                        'email_address' => 'saqib@cicadasys.com',
                        'merge_fields' => ['FNAME'=>'Saqib', 'LNAME'=>'Zafar'],
                        'status'        => 'subscribed',
                    ]);

        print_r($result);
    }

    public function actionTestomnisend(){
        $curl = curl_init();
        $date = date("Y-m-d\TH:i:s.000\Z");

        curl_setopt_array($curl, array(
          CURLOPT_URL => "https://api.omnisend.com/v3/contacts",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => "{
            \"email\":\"vanessa.kensington@example.com\",
            \"createdAt\":\"".$date."\",
            \"firstName\":\"Vanessa\",
            \"lastName\":\"Kensington\",
            \"lists\":[{\"listID\":\"5cd6198f8653ed591c6053c2\"}],
            \"country\":\"USA\",
            \"countryCode\":\"US\",
            \"state\":\"CA\",
            \"city\":\"California\",
            \"address\":\"Someaddress\",
            \"postalCode\":\"SW1A1AA\",
            \"phone\":\"+4430555555531237300\",
            \"status\":\"subscribed\",
            \"statusDate\":\"".$date."\",
            \"sendWelcomeEmail\":false}",
          CURLOPT_HTTPHEADER => array(
            "content-type: application/json",
            "x-api-key: 5ccf24048653ed3e50c944a3-LVaqwU2npZSPWRI85cMAnirgczCzGP2L9h3k56A1G10Kk6rgBP"
          ),
        ));

        $response = curl_exec($curl);
        $err = curl_error($curl);

        curl_close($curl);

        if ($err) {
          echo "cURL Error #:" . $err;
        } else {
          echo $response;
        }
    }

    public function actionTestKlaviyo(){
        // https://www.federalservicedogregistration.org/registration/registration/test-klaviyo/

        $curl = curl_init();
        $date = date("Y-m-d\TH:i:s.000\Z");

        $curl = curl_init();

        // +12345678906 working
        // echo $this->actionTestKlaviyoPhoneNumber('2345678906');

        // ' . $this->actionTestKlaviyoPhoneNumber('8708249326') . '

        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://a.klaviyo.com/api/profiles/',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 30,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
          "data": {
            "type": "profile",
            "attributes": {
                "email": "darren116@fastnet.agency",
                "phone_number": "' . $this->actionTestKlaviyoPhoneNumber('8708249116') . '",
                "external_id": "' . microtime(true) . '",
              "anonymous_id": "",
              "first_name": "Darren116",
              "last_name": "Stevens116",
              "organization": "elit",
              "title": "ea officia ipsum Excepteur ad",
              "image": "in sint",
              "location": {
                "address1": "laboris elit",
                "address2": "sunt eiusmod ut i",
                "city": "in tempor",
                "country": "est in fugiat",
                "latitude": {
                  "value": "<Error: Too many levels of nesting to fake this schema>"
                },
                "longitude": {
                  "value": "<Error: Too many levels of nesting to fake this schema>"
                },
                "region": "dolor proident aliquip laborum",
                "zip": "ex pariatur tempo",
                "timezone": "laboris proident adipisicin"
              },
              "properties": {
                    "Accepts Marketing": "True",
                    "Registration Type": "Service Dog",
                    "Dog Name": "Fido",
                    "Dog Breed": "Poodle"
              }
            }
          }
        }',
          CURLOPT_HTTPHEADER => array(
            'revision: 2022-10-17',
            'Content-Type: application/json',
            'Accept: application/json',
            'Authorization: Klaviyo-API-Key pk_417df30b39426015fe1870791dc741448c'
          ),
        ));

                    // "registration-type": "' . $post['Registrations']['type_of_registration'] . '",
                    // "dog-name": "' . $post['Registrations']['dog_name'] . '",
                    // "dog-breed": "' . $post['Registrations']['dog_breed'] . '"

        $response = curl_exec($curl);

        $err = curl_error($curl);

        curl_close($curl);



        if ($err) {

            // echo "cURL Error #:" . $err;

            // send email to admin.
            // mail( 'darren@fastnet.agency', 'Klaviyo - ERROR - Profile', $err );

        } else {

            // send email to admin.
            // mail( 'darren@fastnet.agency', 'Klaviyo - SUCCESS - Profile', $response );

            $response_string = json_decode( $response );

            // echo '<pre>4 - ';
            // echo print_r( $response_string );
            // echo '</pre>';

            //send email to admin
            // mail( 'darren@fastnet.agency', 'Klaviyo - SUCCESS', $response );

            // Start
            // Profile has been created, now subscribe to a list

            $curl_subscribe = curl_init();

            // Check if profile request returns success or failure.
            $id_data = $response_string->data->id; // Success.
            if ( empty( $id_data ) ) {
                $id_data = $response_string->errors[0]->meta->duplicate_profile_id; // Failure.
            }

            // echo ' //'.$id_data.'// ';

            curl_setopt_array($curl_subscribe, array(
              CURLOPT_URL => 'https://a.klaviyo.com/api/lists/UKrcur/relationships/profiles/',
              CURLOPT_RETURNTRANSFER => true,
              CURLOPT_ENCODING => '',
              CURLOPT_MAXREDIRS => 10,
              CURLOPT_TIMEOUT => 0,
              CURLOPT_FOLLOWLOCATION => true,
              CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
              CURLOPT_CUSTOMREQUEST => 'POST',
              CURLOPT_POSTFIELDS =>'{
                  "data": [
                    {
                      "type": "profile",
                      "id": "' . $id_data . '"
                    }
                  ]
                }',
              CURLOPT_HTTPHEADER => array(
                'revision: 2023-01-24',
                'Content-Type: application/json',
                'Accept: application/json',
                'Authorization: Klaviyo-API-Key pk_417df30b39426015fe1870791dc741448c'
              ),
            ));

            $curl_response = curl_exec($curl_subscribe);

            $curl_err = curl_error($curl_subscribe);

            curl_close($curl_subscribe);
            // echo $curl_response;

            // End

            // echo '<pre>3 - '.getType( $curl_subscribe );
            //     print_r( json_decode( $curl_response ) );
            // echo '</pre>';

        }

    }

    public function actionTestKlaviyoPhoneNumber($no){

        // https://www.federalservicedogregistration.org/registration/registration/test-klaviyo-phone-number/

        // https://stackoverflow.com/questions/52815213/format-a-phone-number-detect-and-add-the-country-code-if-missing

        $number = trim($no);
        $number = str_replace(' ', '', $number);
        $number = str_replace('-', '', $number);
        // $number = stripslashes($number);
        // $number = htmlspecialchars($number);

        //strip out everything but numbers
        $number =  preg_replace("/[^0-9]/", "", $number);
        //Strip out leading zeros:
        $number = ltrim($number, '0');
        //The default country code
        $default_country_code  = '+1';
        //Check if the number doesn't already start with the correct dialling code:
        if ( !preg_match('/^[+]'.$default_country_code.'/', $number)  ) {
            $number = $default_country_code.$number;
        }

        //return the converted number:
        // echo $number;
        return $number;

    }

    /**
     * Updates an existing Registrations model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        //check if own record
        if(Yii::$app->user->id != $model->user_id)
            throw new \yii\web\HttpException(403, 'You are not allowed to access this record.');

        $model->scenario = Registrations::SCENARIO_UPDATE;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Resends email for the registeration
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionResend($id)
    {
        $model = $this->findModel($id);
        //check if own record
        if(Yii::$app->user->id != $model->user_id)
            throw new \yii\web\HttpException(403, 'You are not allowed to access this record.');

        Yii::$app
            ->mailer
            ->compose(
                ['html' => 'registration-html', 'text' => 'registration-text'],
                ['model' => $model]
            )
            ->setFrom([Yii::$app->params['supportEmail'] => Yii::$app->name])
            ->setTo($model->user->email)
            ->setSubject($model->dog_name.'\'s Registration # = '.$model->registration_no.' (Federal Service Dog Registration)')
            ->send();

        Yii::$app->session->setFlash('success', "An email has been sent on your email address, Please check your inbox."); 

        return $this->redirect(['index']);
    }

    public function actionSearch($trakid){

        if (($model = Registrations::findOne(['registration_no' => $trakid])) !== null) {
            return $this->render('view', [
                'model' => $model,
            ]);
        }
        
        return $this->render('notfound');
    }

    /**
     * Finds the Registrations model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Registrations the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Registrations::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
