<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

/* @var $this yii\web\View */
/* @var $model common\models\Registrations */
/* @var $form yii\widgets\ActiveForm */
?>
<style>
    input [type="submit"] {
        color: white;
    }
    .form-control {
        margin-top: 5px;
        border-radius: 0;
    }
</style>
<div class="registrations-form">

    <?php $form = ActiveForm::begin(); ?>

    <?php if($model->hasErrors()) { ?>
        <div class="alert alert-danger" role="alert">
          <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true"></span>
          <span class="sr-only">Errors:</span>
            <?php print_r($model->getErrors()); ?>
        </div>
    <?php } ?>


    <div class="row">
        <div class="col-md-12  well well-sm">
            
            <h4>TYPE OF REGISTRATION:</h4>
            <div class="row">
                <div class="col-md-12">
                    <?php echo $form->field($model, 'type_of_registration')->dropDownList(
                            ['Service Dog' => 'Service Dog', 'Emotional Support Animal' => 'Emotional Support Animal'], 
                            ['prompt'=>'Make Selection *'])->label(false);
                    ?>
                </div>
            </div>
            
            <h4>HANDLER'S NAME:</h4>
            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'handler_first_name')->textInput(['maxlength' => true, 'placeholder' => "First Name *"])->label(false) ?>
                </div>
                 <div class="col-md-6">
                    <?= $form->field($model, 'handler_last_name')->textInput(['maxlength' => true, 'placeholder' => "Last Name *"])->label(false) ?>
                </div>
            </div>
            
            <h4>HANDLER'S ADDRESS:</h4>
            <div class="row">
                <div class="col-md-12">
                    <?= $form->field($model, 'handler_street')->textInput(['maxlength' => true, 'placeholder' => "Street *"])->label(false) ?>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'handler_city')->textInput(['maxlength' => true, 'placeholder' => "City *"])->label(false) ?>
                </div>
                <div class="col-md-6">
                    <?php echo $form->field($model, 'handler_state')->dropDownList(
                        [
                            "AL" => "Alabama",
                            "AK" => "Alaska",
                            "AZ" => "Arizona",
                            "AR" => "Arkansas",
                            "CA" => "California",
                            "CO" => "Colorado",
                            "CT" => "Connecticut",
                            "DE" => "Delaware",
                            "DC" => "District of Columbia",
                            "FL" => "Florida",
                            "GA" => "Georgia",
                            "HI" => "Hawaii",
                            "ID" => "Idaho",
                            "IL" => "Illinois",
                            "IN" => "Indiana",
                            "IA" => "Iowa",
                            "KS" => "Kansas",
                            "KY" => "Kentucky",
                            "LA" => "Louisiana",
                            "ME" => "Maine",
                            "MD" => "Maryland",
                            "MA" => "Massachusetts",
                            "MI" => "Michigan",
                            "MN" => "Minnesota",
                            "MS" => "Mississippi",
                            "MO" => "Missouri",
                            "MT" => "Montana",
                            "NE" => "Nebraska",
                            "NV" => "Nevada",
                            "NH" => "New Hampshire",
                            "NJ" => "New Jersey",
                            "NM" => "New Mexico",
                            "NY" => "New York",
                            "NC" => "North Carolina",
                            "ND" => "North Dakota",
                            "OH" => "Ohio",
                            "OK" => "Oklahoma",
                            "OR" => "Oregon",
                            "PA" => "Pennsylvania",
                            "PR" => "Puerto Rico",
                            "RI" => "Rhode Island",
                            "SC" => "South Carolina",
                            "SD" => "South Dakota",
                            "TN" => "Tennessee",
                            "TX" => "Texas",
                            "UT" => "Utah",
                            "VT" => "Vermont",
                            "VA" => "Virginia",
                            "WA" => "Washington",
                            "WV" => "West Virginia",
                            "WI" => "Wisconsin",
                            "WY" => "Wyoming",
                            "OTHER" => "Other",
                            
                        ], 
                        ['prompt'=>'State *'])->label(false);
                    ?>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'handler_zip')->textInput(['maxlength' => true, 'placeholder' => "Zip *"])->label(false) ?>
                </div>
                 <div class="col-md-6">
                    <?= $form->field($model, 'handler_phone')->textInput(['maxlength' => true, 'placeholder' => "Phone *"])->label(false) ?>
                </div>
            </div>

            <h4>DOG'S INFORMATION:</h4>
            <div class="row">
                <div class="col-md-12">
                    <?= $form->field($model, 'dog_name')->textInput(['maxlength' => true, 'placeholder' => "Dog's Name *"])->hint('(maximum of 22 characters)')->label(false); ?>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <?php echo $form->field($model, 'dog_breed')->dropDownList(
                        [
                            "Mixed " => "Mixed ",
                            "Other" => "Other",
                            "Affenpinscher" => "Affenpinscher",
                            "Afghan Hound" => "Afghan Hound",
                            "Airedale Terrier" => "Airedale Terrier",
                            "Akita" => "Akita",
                            "Alaskan Malamute" => "Alaskan Malamute",
                            "American English Coonhound" => "American English Coonhound",
                            "American Eskimo Dog" => "American Eskimo Dog",
                            "American Hairless Terrier" => "American Hairless Terrier",
                            "American Staffordshire Terrier" => "American Staffordshire Terrier",
                            "Anatolian Shepherd" => "Anatolian Shepherd",
                            "Australian Cattle Dog" => "Australian Cattle Dog",
                            "Australian Shepherd" => "Australian Shepherd",
                            "Australian Terrier" => "Australian Terrier",
                            "Azawakh" => "Azawakh",
                            "Barbet" => "Barbet",
                            "Basenji" => "Basenji",
                            "Basset Hound" => "Basset Hound",
                            "Beagle" => "Beagle",
                            "Bearded Collie" => "Bearded Collie",
                            "Beauceron" => "Beauceron",
                            "Bedlington Terrier" => "Bedlington Terrier",
                            "Belgian Laekenois" => "Belgian Laekenois",
                            "Belgian Malinois" => "Belgian Malinois",
                            "Belgian Sheepdog" => "Belgian Sheepdog",
                            "Belgian Tervuren" => "Belgian Tervuren",
                            "Bergamasco" => "Bergamasco",
                            "Berger Picard" => "Berger Picard",
                            "Bernese Mountain Dog" => "Bernese Mountain Dog",
                            "Bichon Frise" => "Bichon Frise",
                            "Biewer Terrier" => "Biewer Terrier",
                            "Black and Tan Coonhound" => "Black and Tan Coonhound",
                            "Black Russian Terrier" => "Black Russian Terrier",
                            "Bloodhound" => "Bloodhound",
                            "Bluetick Coonhound" => "Bluetick Coonhound",
                            "Boerboel" => "Boerboel",
                            "Border Collie" => "Border Collie",
                            "Border Terrier" => "Border Terrier",
                            "Borzoi" => "Borzoi",
                            "Boston Terrier" => "Boston Terrier",
                            "Bouvier des Flandres" => "Bouvier des Flandres",
                            "Boxer" => "Boxer",
                            "Boykin Spaniel" => "Boykin Spaniel",
                            "Briard" => "Briard",
                            "Brittany" => "Brittany",
                            "Brussels Griffon" => "Brussels Griffon",
                            "Bull Terrier" => "Bull Terrier",
                            "Bulldog" => "Bulldog",
                            "Bullmastiff" => "Bullmastiff",
                            "Cairn Terrier" => "Cairn Terrier",
                            "Canaan Dog" => "Canaan Dog",
                            "Cane Corso" => "Cane Corso",
                            "Cavalier King Charles Spaniel" => "Cavalier King Charles Spaniel",
                            "Cesky Terrier" => "Cesky Terrier",
                            "Chihuahua" => "Chihuahua",
                            "Chinese Crested" => "Chinese Crested",
                            "Chinese Shar-Pei" => "Chinese Shar-Pei",
                            "Chinook" => "Chinook",
                            "Chow Chow" => "Chow Chow",
                            "Cirneco dell’Etna" => "Cirneco dell’Etna",
                            "Collie" => "Collie",
                            "Coton de Tulear" => "Coton de Tulear",
                            "Dachshund" => "Dachshund",
                            "Dalmatian" => "Dalmatian",
                            "Dandie Dinmont Terrier" => "Dandie Dinmont Terrier",
                            "Doberman Pinscher" => "Doberman Pinscher",
                            "Dogo Argentino" => "Dogo Argentino",
                            "Dogue de Bordeaux" => "Dogue de Bordeaux",
                            "English Toy Spaniel" => "English Toy Spaniel",
                            "Entlebucher Mountain Dog" => "Entlebucher Mountain Dog",
                            "Finnish Lapphund" => "Finnish Lapphund",
                            "Finnish Spitz" => "Finnish Spitz",
                            "Fox Terrier" => "Fox Terrier",
                            "Foxhound (American)" => "Foxhound (American)",
                            "Foxhound (English)" => "Foxhound (English)",
                            "French Bulldog" => "French Bulldog",
                            "German Pinscher" => "German Pinscher",
                            "German Shepherd Dog" => "German Shepherd Dog",
                            "Giant Schnauzer" => "Giant Schnauzer",
                            "Glen of Imaal Terrier" => "Glen of Imaal Terrier",
                            "Grand Basset Griffon Vendéen" => "Grand Basset Griffon Vendéen",
                            "Great Dane" => "Great Dane",
                            "Great Pyrenees" => "Great Pyrenees",
                            "Greater Swiss Mountain Dog" => "Greater Swiss Mountain Dog",
                            "Greyhound" => "Greyhound",
                            "Harrier" => "Harrier",
                            "Havanese" => "Havanese",
                            "Ibizan Hound" => "Ibizan Hound",
                            "Icelandic Sheepdog" => "Icelandic Sheepdog",
                            "Irish Red &amp; White Setter" => "Irish Red &amp; White Setter",
                            "Irish Terrier" => "Irish Terrier",
                            "Irish Wolfhound" => "Irish Wolfhound",
                            "Italian Greyhound" => "Italian Greyhound",
                            "Japanese Chin" => "Japanese Chin",
                            "Keeshond" => "Keeshond",
                            "Kerry Blue Terrier" => "Kerry Blue Terrier",
                            "Komondor" => "Komondor",
                            "Kuvasz" => "Kuvasz",
                            "Lagotto Romagnolo" => "Lagotto Romagnolo",
                            "Lakeland Terrier" => "Lakeland Terrier",
                            "Leonberger" => "Leonberger",
                            "Lhasa Apso" => "Lhasa Apso",
                            "Löwchen" => "Löwchen",
                            "Maltese" => "Maltese",
                            "Manchester Terrier (Standard)" => "Manchester Terrier (Standard)",
                            "Manchester Terrier (Toy)" => "Manchester Terrier (Toy)",
                            "Mastiff" => "Mastiff",
                            "Miniature American Shepherd" => "Miniature American Shepherd",
                            "Miniature Bull Terrier" => "Miniature Bull Terrier",
                            "Miniature Pinscher" => "Miniature Pinscher",
                            "Miniature Schnauzer" => "Miniature Schnauzer",
                            "Neapolitan Mastiff" => "Neapolitan Mastiff",
                            "Nederlandse Kooikerhondje" => "Nederlandse Kooikerhondje",
                            "Newfoundland" => "Newfoundland",
                            "Norfolk Terrier" => "Norfolk Terrier",
                            "Norwegian Buhund" => "Norwegian Buhund",
                            "Norwegian Elkhound" => "Norwegian Elkhound",
                            "Norwegian Lundehund" => "Norwegian Lundehund",
                            "Norwich Terrier" => "Norwich Terrier",
                            "Nova Scotia Duck Tolling Retriever" => "Nova Scotia Duck Tolling Retriever",
                            "Old English Sheepdog" => "Old English Sheepdog",
                            "Otterhound" => "Otterhound",
                            "Papillon" => "Papillon",
                            "Parson Russell Terrier" => "Parson Russell Terrier",
                            "Pekingese" => "Pekingese",
                            "Pembroke Welsh Corgi" => "Pembroke Welsh Corgi",
                            "Petit Basset Griffon Vendéen" => "Petit Basset Griffon Vendéen",
                            "Pharoah Hound" => "Pharoah Hound",
                            "Plott" => "Plott",
                            "Pointer" => "Pointer",
                            "Pointer (German Shorthaired)" => "Pointer (German Shorthaired)",
                            "Pointer (German Wirehaired)" => "Pointer (German Wirehaired)",
                            "Polish Lowland Sheepdog" => "Polish Lowland Sheepdog",
                            "Pomeranian" => "Pomeranian",
                            "Poodle" => "Poodle",
                            "Portuguese Podengo Pequeno" => "Portuguese Podengo Pequeno",
                            "Portugese Water Dog" => "Portugese Water Dog",
                            "Pug" => "Pug",
                            "Puli" => "Puli",
                            "Pumi" => "Pumi",
                            "Pyrenean Shepherd" => "Pyrenean Shepherd",
                            "Rat Terrier" => "Rat Terrier",
                            "Redbone Coonhound" => "Redbone Coonhound",
                            "Retriever (Chesapeake Bay)" => "Retriever (Chesapeake Bay)",
                            "Retriever (Curly-Coated)" => "Retriever (Curly-Coated)",
                            "Retriever (Flat-Coated)" => "Retriever (Flat-Coated)",
                            "Retriever (Golden)" => "Retriever (Golden)",
                            "Retriever (Labrador)" => "Retriever (Labrador)",
                            "Rhodesian Ridgeback" => "Rhodesian Ridgeback",
                            "Rottweiler" => "Rottweiler",
                            "Russell Terrier" => "Russell Terrier",
                            "Saint Bernard" => "Saint Bernard",
                            "Saluki" => "Saluki",
                            "Samoyed" => "Samoyed",
                            "Schipperke" => "Schipperke",
                            "Scottish Deerhound" => "Scottish Deerhound",
                            "Scottish Terrier" => "Scottish Terrier",
                            "Sealyham Terrier" => "Sealyham Terrier",
                            "Setter (English)" => "Setter (English)",
                            "Setter (Gordon)" => "Setter (Gordon)",
                            "Setter (Irish)" => "Setter (Irish)",
                            "Shetland Sheepdog" => "Shetland Sheepdog",
                            "Shiba Inu" => "Shiba Inu",
                            "Shih Tzu" => "Shih Tzu",
                            "Siberian Husky" => "Siberian Husky",
                            "Silky Terrier" => "Silky Terrier",
                            "Skye Terrier" => "Skye Terrier",
                            "Sloughi" => "Sloughi",
                            "Soft Coated Wheaten Terrier" => "Soft Coated Wheaten Terrier",
                            "Spaniel (American Water)" => "Spaniel (American Water)",
                            "Spaniel (Clumber)" => "Spaniel (Clumber)",
                            "Spaniel (Cocker)" => "Spaniel (Cocker)",
                            "Spaniel (English Cocker)" => "Spaniel (English Cocker)",
                            "Spaniel (English Springer)" => "Spaniel (English Springer)",
                            "Spaniel (Field)" => "Spaniel (Field)",
                            "Spaniel (Irish Water)" => "Spaniel (Irish Water)",
                            "Spaniel (Sussex)" => "Spaniel (Sussex)",
                            "Spaniel (Welsh Springer)" => "Spaniel (Welsh Springer)",
                            "Spanish Water Dog" => "Spanish Water Dog",
                            "Spinone Italiano" => "Spinone Italiano",
                            "Staffordshire Bull Terrier" => "Staffordshire Bull Terrier",
                            "Standard Schnauzer" => "Standard Schnauzer",
                            "Swedish Vallhund" => "Swedish Vallhund",
                            "Tibetan Mastiff" => "Tibetan Mastiff",
                            "Tibetan Spaniel" => "Tibetan Spaniel",
                            "Tibetan Terrier" => "Tibetan Terrier",
                            "Toy Fox Terrier" => "Toy Fox Terrier",
                            "Treeing Walker Coonhound" => "Treeing Walker Coonhound",
                            "Vizsla" => "Vizsla",
                            "Weimaraner" => "Weimaraner",
                            "Welsh Corgi (Cardigan)" => "Welsh Corgi (Cardigan)",
                            "Welsh Corgi (Pembroke)" => "Welsh Corgi (Pembroke)",
                            "Welsh Terrier" => "Welsh Terrier",
                            "West Highland White Terrier" => "West Highland White Terrier",
                            "Yorkshire Terrier" => "Yorkshire Terrier",
                            "Whippet" => "Whippet",
                            "Wirehaired Pointing Griffon" => "Wirehaired Pointing Griffon",
                            "Wirehaired Vizsla" => "Wirehaired Vizsla",
                            "Xoloitzcuintli" => "Xoloitzcuintli",
                        ], 
                        ['prompt'=>'Choose A Breed *'])->label(false);
                    ?>
                </div>
            </div>

            <h4>YOUR ACCOUNT INFORMATION:</h4>
            <?php if($model->isNewRecord) : ?>
                <div class="row">
                    <div class="col-md-6">
                        <?= $form->field($model, 'email')->textInput(['maxlength' => true, 'placeholder' => "Email *"])->label(false) ?>
                    </div>
                     <div class="col-md-6">
                        <?= $form->field($model, 'repeat_email')->textInput(['maxlength' => true, 'placeholder' => "Repeat Email *"])->label(false) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?= $form->field($model, 'password')->passwordInput(['maxlength' => true, 'placeholder' => "Password *"])->label(false) ?>
                    </div>
                     <div class="col-md-6">
                        <?= $form->field($model, 'repeat_password')->passwordInput(['maxlength' => true, 'placeholder' => "Repeat Password *"])->label(false) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?= $form->field($model, 'verifyCode')->widget(\yii\captcha\Captcha::classname(), [
                            // configure additional widget properties here
                            'template' => '<div class="captcha_img">{image}'
                            . '<a class="refreshcaptcha" href="#">'
                            .'</a></div>'//. Html::img('/images/reload.png',['width' => '30px'])
                            . 'Click text to change code {input}',
                            'imageOptions' => [
                                'id' => 'my-captcha-image'
                            ]
                        ]); ?>
                    </div>
                </div>
            <?php endif; ?>

            <div class="form-group">
                <?= Html::submitButton(Yii::t('app', 'Submit'), ['class' => 'btnsub', 'style' => '']) ?>
                <p>*BY SIGNING UP YOU AGREE TO RECEIVE EMAIL MARKETING FROM FEDERAL SERVICE DOG & TOP DOG PRODUCTS.<br />AFTER SUBMISSION YOU CAN EDIT PROFILE USING LOGIN BUTTON ABOVE</p>
            </div>

            <?php ActiveForm::end(); ?>

        </div>
        <!-- <div class="col-md-6">
            <div class="image-div">
                <img src="/images/banner-1.jpg" alt="Service Dog">
            </div>
        </div> -->
    </div>
</div>

<br>
<script type="text/javascript">
    //resets all form when you click back button in browser
    $(window).bind("pageshow", function() {
        $("form").trigger("reset");
    });
    
    $('form').on('beforeSubmit', function()
    {
        var $form = $(this);
        //console.log('before submit');

        var $submit = $form.find(':submit');
        $submit.html('<span class="fa fa-spin fa-spinner"></span>');
        $submit.prop('disabled', true);

    });
</script>
